<?php
/**
 * Setup Group Wiki Post Type
 *
 * @package Nisje
 */

namespace Nisje\Extension\Wiki\Groups\PostType;

use const Nisje\Extension\Wiki\Groups\{
	POST_TYPE_NAME,
	POST_TYPE_REST,
	GROUP_META_KEY,
	GRAPHQL_NAME
};
use const Nisje\Constants\GROUP_POST_CAP;
use function Nisje\GroupConnection\Utils\{
	add_group_connection_meta,
	get_default_post_type_args
};

/**
 * Add meta connection
 */
add_group_connection_meta( POST_TYPE_NAME, GROUP_META_KEY );

/**
 * Register the Group Wiki post type.
 */
function register_post_type() {
	$args = apply_filters( 'nisje/wiki/groups/post_type_args', \wp_parse_args( [
		'labels'              => [
			'name'          => \__( 'Group Wiki', 'nisje' ),
			'singular_name' => \__( 'Group Wiki', 'nisje' ),
		],
		'rewrite'             => [
			'slug'       => 'groups/%group_id%/wiki/%post_id%',
			'with_front' => false,
		],
		'supports'            => [
			'author',
			'editor',
			'excerpt',
			'revisions',
			'thumbnail',
			'title',
		],
		'rest_base'           => POST_TYPE_REST,
		'graphql_single_name' => GRAPHQL_NAME,
		'graphql_plural_name' => GRAPHQL_NAME . 's',
	], get_default_post_type_args() ) );

	\register_post_type( POST_TYPE_NAME, $args );
}
\add_action( 'init', __NAMESPACE__ . '\\register_post_type' );

/**
 * Add feed post types.
 *
 * @param array $post_types Current Post Types.
 * @return array $post_types Populated Post Types.
 */
function add_feed_post_types( array $post_types ): array {
	$post_types[] = POST_TYPE_NAME;
	return $post_types;
}
\add_filter( 'nisje_feed_post_types', __NAMESPACE__ . '\\add_feed_post_types' );

/**
 * Override permissions for group wiki.
 *
 * @param bool   $allowed   Current permission.
 * @param string $post_type Post type.
 */
function override_rest_permission_check( $allowed, $post_type ) {
	if ( POST_TYPE_NAME === $post_type ) {
		return true;
	}

	return $allowed;
}
\add_filter( 'nisje_override_rest_permission_check', __NAMESPACE__ . '\\override_rest_permission_check', 10, 2 );
