/**
 * WordPress dependencies
 */
import { __ } from '@wordpress/i18n';
import { hasQueryArg, getQueryArg } from '@wordpress/url';
import { Modal, SelectControl } from '@wordpress/components';
import { PluginDocumentSettingPanel } from '@wordpress/edit-post';
import { registerPlugin } from '@wordpress/plugins';
import { store as editorStore } from '@wordpress/editor';
import { useEffect } from '@wordpress/element';
import { useEntityProp } from '@wordpress/core-data';
import { useSelect } from '@wordpress/data';

const groups = window.nisjeGroupConnections;

registerPlugin('nisje-group-connection', {
	icon: null,
	render() {
		const postType = useSelect(
			(select) => select(editorStore).getCurrentPostType(),
			[],
		);
		const [groupId, setGroupId] = useEntityProp(
			'postType',
			postType,
			'group_id',
		);

		useEffect(() => {
			if (groupId === 0) {
				const URL = window.location.href;
				if (hasQueryArg(URL, 'group_id')) {
					const id = parseInt(getQueryArg(URL, 'group_id'), 10);

					if (groups.some((group) => group.value === id)) {
						setGroupId(id);
					}
				}
			}
		}, []);

		function handleMetaChange(value) {
			setGroupId(parseInt(value, 10));
		}

		return (
			<>
				{groupId !== 0 && (
					<PluginDocumentSettingPanel
						name="nisje-group-connection"
						title={__('Group', 'nisje')}
					>
						<SelectControl
							label={__('Select group', 'nisje')}
							value={groupId}
							options={groups}
							onChange={handleMetaChange}
						/>
					</PluginDocumentSettingPanel>
				)}
				{groupId === 0 && (
					<Modal
						title={__('Select group', 'nisje')}
						isDismissible={false}
					>
						<SelectControl
							label={__('Select group', 'nisje')}
							value={groupId}
							options={[{ label: '---', value: 0 }, ...groups]}
							onChange={handleMetaChange}
						/>
					</Modal>
				)}
			</>
		);
	},
});
