<?php
/**
 * Setup News Post Type
 *
 * @package Nisje
 */

namespace Nisje\Extension\News\PostType;

const NAME           = 'dekode-news';
const CAP            = 'di_news';
const REST           = 'dekode-news';
const GRAPHQL        = 'news';
const GRAPHQL_PLURAL = 'newss';

/**
 * Register the News post type.
 */
function register_post_type() {
	$args = \apply_filters( 'nisje/news/post_type_args', [
		'labels'                => [
			'name'          => \__( 'News', 'nisje' ),
			'singular_name' => \__( 'News', 'nisje' ),
		],
		'public'                => true,
		'publicly_queryable'    => true,
		'exclude_from_search'   => false,
		'show_in_admin_bar'     => false,
		'show_in_nav_menus'     => false,
		'can_export'            => false,
		'show_ui'               => true,
		'query_var'             => false,
		'has_archive'           => false,
		'rewrite'               => [
			'slug'       => 'news/%post_id%',
			'with_front' => false,
		],
		'capability_type'       => CAP,
		'capabilities'          => [
			'create_posts'     => 'create_' . CAP . 's',
			'delete_posts'     => 'delete_' . CAP . 's',
			'upload_files_cpt' => 'upload_files_' . CAP,
		],
		'map_meta_cap'          => true,
		'hierarchical'          => false,
		'menu_position'         => null,
		'menu_icon'             => 'dashicons-megaphone',
		'supports'              => [
			'author',
			'title',
			'revisions',
			'editor',
			'thumbnail',
			'comments',
			'excerpt',
		],
		'show_in_rest'          => true,
		'rest_base'             => REST,
		'rest_controller_class' => 'WP_REST_Posts_Controller',
		'show_in_graphql'       => true,
		'graphql_single_name'   => GRAPHQL,
		'graphql_plural_name'   => GRAPHQL_PLURAL,
	] );

	\register_post_type( NAME, $args );
}
\add_action( 'init', __NAMESPACE__ . '\\register_post_type' );
