<?php
/**
 * Restrict access to Group Wiki
 *
 * @package Nisje
 */

namespace Nisje\Extension\Wiki\Groups\GraphQL;

use \GraphQL\Type\Introspection;
use \GraphQL\Error\UserError;

/**
 * Restrict access to Group Wiki
 *
 * @param string $query     The GraphQL query.
 * @param string $operation The operation name.
 * @param array  $variables The GraphQL variables.
 *
 * @throws UserError Error if not allowed.
 */
function restrict_group_wiki_access( $query, $operation, $variables ): void {
	if ( ! defined( 'GRAPHQL_HTTP_REQUEST' ) || true !== GRAPHQL_HTTP_REQUEST ) {
		return;
	}

	$is_group_wiki_query = 'getGroupWikiPost' === $operation;

	if ( false !== strpos( $query, 'groupWiki' ) && ! $is_group_wiki_query ) {
		throw new UserError( \__( 'Sorry, this endpoint is restricted.', 'nisje' ) );
	}

	if ( ! $is_group_wiki_query ) {
		return;
	}

	$wiki_id  = \absint( $variables['id'] );
	$group_id = \wp_get_post_parent_id( $wiki_id );
	$group    = \groups_get_group( $group_id );

	if ( empty( $group ) || empty( $group->id ) ) {
		throw new UserError( __( 'Group not found.', 'nisje' ) );
	}

	$user_id = \get_current_user_id();

	if ( in_array( $group->status, [ 'hidden', 'private' ], true ) && ! \groups_is_user_member( $user_id, $group->id ) ) {
		throw new UserError( __( 'Sorry, you need to be a member of the group to see this post.', 'nisje' ) );
	}
}
\add_action( 'do_graphql_request', __NAMESPACE__ . '\\restrict_group_wiki_access', 10, 3 );
