<?php
/**
 * Optimizations
 *
 * @package Nisje
 */

declare( strict_types = 1 );
namespace Nisje\Optimizations;

/**
 * Allow additional tags
 *
 * @param array $allowed Allowed tags.
 */
function allowed_html( array $allowed ): array {
	$allowed['nisje-mention'] = [
		'class'      => true,
		'data-id'    => true,
		'data-value' => true,
	];

	return $allowed;
}
\add_filter( 'wp_kses_allowed_html', __NAMESPACE__ . '\\allowed_html', 10, 1 );

/**
 * Add group to post permalink.
 *
 * @param string   $post_link The post's permalink.
 * @param \WP_Post $post      The post in question.
 */
function add_group_to_post_link( string $post_link, \WP_Post $post ): string {
	if ( false === strpos( $post_link, '%group_id%' ) ) {
		return $post_link;
	}

	return str_replace( '%group_id%', $post->post_parent, $post_link );
}
\add_filter( 'post_type_link', __NAMESPACE__ . '\\add_group_to_post_link', 10, 2 );
