<?php
/**
 * Email template: Header.
 *
 * @package Nisje
 */

$defaults = [
	'title' => '',
	'logo'  => '',
	'date'  => '',
];

$args = wp_parse_args( $args, $defaults );
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional //EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd" />
<html lang="en" xmlns="http://www.w3.org/1999/xhtml" xmlns:v="urn:schemas-microsoft-com:vml" xmlns:o="urn:schemas-microsoft-com:office:office">
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
	<meta name="viewport" content="width=device-width, initial-scale=1.0" />
	<meta name="x-apple-disable-message-reformatting" />
	<!--[if !mso]><!-->
	<meta http-equiv="X-UA-Compatible" content="IE=edge" />
	<!--<![endif]-->
	<style type="text/css">
		* {
			text-size-adjust: 100%;
			-ms-text-size-adjust: 100%;
			-moz-text-size-adjust: 100%;
			-webkit-text-size-adjust: 100%;
		}

		html {
			height: 100%;
			width: 100%;
		}

		body {
			height: 100% !important;
			margin: 0 !important;
			padding: 0 !important;
			width: 100% !important;
			mso-line-height-rule: exactly;
		}

		div[style*="margin: 16px 0"] {
			margin: 0 !important;
		}

		table,
		td {
			mso-table-lspace: 0pt;
			mso-table-rspace: 0pt;
		}

		img {
			border: 0;
			height: auto;
			line-height: 100%;
			outline: none;
			text-decoration: none;
			-ms-interpolation-mode: bicubic;
		}

		.ReadMsgBody,
		.ExternalClass {
			width: 100%;
		}

		.ExternalClass,
		.ExternalClass p,
		.ExternalClass span,
		.ExternalClass td,
		.ExternalClass div {
			line-height: 100%;
		}
	</style>
	<!--[if gte mso 9]>
		<style type="text/css">
			li { text-indent: -1em; }
			table td { border-collapse: collapse; }
		</style>
	<![endif]-->
	<title><?php echo esc_html( $args['title'] ); ?></title>
	<!-- content -->
	<!--[if gte mso 9]>
		<xml>
			<o:OfficeDocumentSettings>
				<o:AllowPNG/>
				<o:PixelsPerInch>96</o:PixelsPerInch>
			</o:OfficeDocumentSettings>
		</xml>
	<![endif]-->
</head>
<body class="body" style="background-color: #FFFFFF; margin: 0; width: 100%;">
	<table class="bodyTable" role="presentation" width="100%" align="left" border="0" cellpadding="0" cellspacing="0" style="width: 100%; background-color: #FFFFFF; margin: 0;" bgcolor="#FFFFFF">
		<tr>
			<td class="body__content" align="left" width="100%" valign="top" style="color: #000000; font-size: 16px; line-height: 20px; font-family: 'Open Sans',Helvetica,Arial,Calibri,sans-serif;">
				<div class="container" style="margin: 0 auto; width: 100%; max-width: 640px;">
				<!--[if mso | IE]>
				<table class="container__table__ie" role="presentation" border="0" cellpadding="0" cellspacing="0" style="margin-right: auto; margin-left: auto;width: 640px" width="640" align="center">
					<tr>
						<td>
				<![endif]-->
					<table class="container__table" role="presentation" border="0" align="center" cellpadding="0" cellspacing="0" width="100%">
						<tr class="container__row">
							<td class="container__cell" width="100%" align="left" valign="top" style="padding-left: 10px; padding-right: 10px;">
								<div class="header block" style="width: 100%; color: #000000; font-family: 'Open Sans',Helvetica,Arial,Calibri,sans-serif;">
									<!--[if mso | IE]>
									<table class="block__table__ie" role="presentation" border="0" cellpadding="0" cellspacing="0" style="width: 100%" width="640">
										<tr>
											<td>
									<![endif]-->
									<table class="block__table" role="presentation" border="0" align="center" cellpadding="0" cellspacing="0" width="100%">
										<tr class="block__row">
											<td class="block__cell" width="100%" align="left" valign="top">
												<div style="text-align:center;padding-top:25px;padding-bottom:25px;padding-right:0;padding-left:0">
													<a href="<?php echo esc_url( $args['home_url'] ); ?>" class="no-underline a" style="color: #121921; text-decoration: none;">
														<span class="a__text" style="color: #121921; text-decoration: none;">
															<?php
															if ( ! empty( $args['logo'] ) ) {
																printf( '<img src="%s" alt="%s" border="0" class="img__block" style="max-width: 100%; width: 145px; margin: 20px auto 0; display: block;" width="145" />',
																	esc_url( $args['logo'] ),
																	esc_attr( $args['title'] )
																);
															} else {
																printf( '<h1 class="font-secondary inline header h1" style="margin: 20px 0; line-height: 40px; font-size: 24px; font-weight: 700; margin-bottom: 0; margin-top: 20px; text-transform: uppercase; color: #121921; font-family: \'Roboto Mono\',Menlo,\'Courier New\',Courier,monospace; display: inline-block; text-align: center;">%s</h1>',
																	esc_html( $args['title'] )
																);
															}
															?>
														</span>
													</a>
													<p class="font-secondary font-size-small text p" style="display: block; line-height: 20px; color: #121921; font-family: 'Roboto Mono',Menlo,'Courier New',Courier,monospace; font-size: 12px; text-align: center; margin: 12px 0 0;"><?php echo esc_html( $args['date'] ); ?></p>
												</div>
											</td>
										</tr>
									</table>
									<!--[if mso | IE]>
											</td>
										</tr>
									</table>
									<![endif]-->
								</div>
