<?php
/**
 * Email template: User post.
 *
 * @package Nisje
 */

$defaults = [
	'tags'    => [],
	'name'    => 'Unknown',
	'content' => '',
];

$user_post = wp_parse_args( $user_post, $defaults );

?>
<div class="user-post block" style="width: 100%;">
	<!--[if mso | IE]>
	<table class="block__table__ie" role="presentation" border="0" cellpadding="0" cellspacing="0" style="width: 100%" width="640">
		<tr>
			<td>
	<![endif]-->
	<table class="block__table" role="presentation" border="0" align="center" cellpadding="0" cellspacing="0" width="100%">
		<tr class="block__row">
			<td class="block__cell" width="100%" align="left" valign="top" style="border-bottom: 1px solid #E6E5E6; padding: 30px 20px;">
				<?php
				if ( isset( $groups[ $user_post['group_id'] ] ) ) :
					?>
					<p class="group font-size-small font-secondary text p" style="display: block; font-family: 'Roboto Mono',Menlo,'Courier New',Courier,monospace; font-size: 12px; color: #121921; line-height: 1em; margin: 0 0 14px; vertical-align: middle;">
						<a href="<?php echo esc_url( $args['home_url'] . 'groups/' . $user_post['group_id'] ); ?>" class="inline no-underline mr-5 a" style="color: #121921; display: inline-block; text-decoration: none; margin-right: 5px; width: 20px; vertical-align: middle; height: 20px; font-size: 0;">
							<span class="a__text" style="color: #121921; text-decoration: none;">
								<img alt="" src="<?php echo esc_url( $groups[ $user_post['group_id'] ]['avatar'] ); ?>" width="20" height="20" border="0" class="img__block" style="display: block; max-width: 100%; width: 20px; height: 20px; border-radius: 2px;" />
							</span>
						</a>
						<a href="<?php echo esc_url( $args['home_url'] . 'groups/' . $user_post['group_id'] ); ?>" class="group no-underline a" style="color: #121921; text-decoration: none; vertical-align: middle;"><span class="a__text" style="color: #121921; text-decoration: none;"><?php echo esc_html( $groups[ $user_post['group_id'] ]['name'] ); ?></span></a>
					</p>
					<?php
				endif;

				if ( ! empty( $user_post['images'] ) ) {
					?>
					<span class="image-group" style="border-radius: 4px; display: block; margin-bottom: 14px; overflow: hidden; padding-bottom: 56%; position: relative;">
						<?php
						$images_count = count( $user_post['images'] );

						if ( 1 === $images_count ) {
							$style = [
								'width: 100%; height: 100%;',
							];
						} elseif ( 2 === $images_count ) {
							$style = [
								'width: 50%; height: 100%;',
								'width: 50%; height: 100%; right: 0;',
							];
						} elseif ( 3 === $images_count ) {
							$style = [
								'width: 50%; height: 100%;',
								'width: 50%; height: 50%; right: 0;',
								'width: 50%; height: 50%; right: 0; bottom: 0;',
							];
						} else {
							$style = [
								'width: 50%; height: 50%;',
								'width: 50%; height: 50%; right: 0;',
								'width: 50%; height: 50%; bottom: 0;',
								'width: 50%; height: 50%; right: 0; bottom: 0;',
							];
						}

						for ( $i = 0; $i < $images_count; $i++ ) {
							if ( $i < 4 ) :
								$image_id = $user_post['images'][ $i ];
								?>
								<span style="<?php echo esc_attr( $style[ $i ] ); ?>background-size: cover; position: absolute; background-image: url(<?php echo esc_url( \wp_get_attachment_image_src( $image_id, 'medium' )[0] ); ?>"></span>
								<?php
							endif;
						}
						?>

					</span>
					<?php
				}

				if ( ! empty( $user_post['content'] ) ) {
					printf( '<p class="user-content text p" style="display: block; margin: 14px 0; line-height: 20px; color: #121921; font-family: \'Open Sans\',Helvetica,Arial,Calibri,sans-serif; font-size: 14px; margin-top: 0;">%s</p>',
						esc_html( $user_post['content'] )
					);
				}
				?>
				<p class="font-secondary font-size-small text p" style="display: block; line-height: 20px; color: #121921; font-family: 'Roboto Mono',Menlo,'Courier New',Courier,monospace; font-size: 12px; margin: 20px 0 0;">
					<span class="inline" style="display: inline-block;">
						<?php
						printf( '<span class="inline" style="display: inline-block;"> by <strong><a href="%s" class="inline mr-5 a" style="color: #121921; text-decoration: underline; display: inline-block; margin-right: 5px;"><span class="a__text" style="color: #121921; text-decoration: underline;">%s</span></a></strong></span>',
							esc_url( $user_post['author_url'] ),
							esc_html( $user_post['author'] )
						);
						?>
						<span class="inline mr-5" style="display: inline-block; margin-right: 5px;">•</span>
						<span class="inline" style="display: inline-block;">
							<?php
							printf( '<a href="%s" class="inline mr-5 a" style="color: #121921; text-decoration: underline; display: inline-block; margin-right: 5px;"><span class="a__text" style="color: #121921; text-decoration: underline;">%s</span></a>',
								esc_url( $args['home_url'] . 'activity/' . $user_post['id'] ),
								esc_html( $user_post['comments_count'] . ' comment' )
							);
							?>
						</span>
						<?php
						if ( ! empty( $user_post['tags'] ) ) {
							printf( '<span class="inline mr-5" style="display: inline-block; margin-right: 5px;">•</span>' );
							printf( '<span class="inline" style="display: inline-block;">' );
							foreach ( $user_post['tags'] as $post_tag ) {
								printf( ' <a href="%s" class="inline mr-5 a" style="color: #121921; text-decoration: underline; display: inline-block; margin-right: 5px;"><span class="a__text" style="color: #121921; text-decoration: underline;">%s</span></a>',
									esc_url( $args['home_url'] . 'tag/' . $post_tag->term_id ),
									'#' . esc_html( $post_tag->name )
								);
							}
							printf( '</span>' );
						}
						?>
					</span>
				</p>
			</td>
		</tr>
	</table>
	<!--[if mso | IE]>
			</td>
		</tr>
	</table>
	<![endif]-->
</div>
