<?php
/**
 * Setup Wiki Post Type
 *
 * @package Nisje
 */

namespace Nisje\Extension\Wiki\PostType;

const NAME           = 'dekode-wiki';
const CAP            = 'di_wiki';
const REST           = 'dekode-wiki';
const GRAPHQL        = 'wiki';
const GRAPHQL_PLURAL = 'wikis';

/**
 * Register the Wiki post type.
 */
function register_post_type() {
	$args = \apply_filters( 'nisje/wiki/post_type_args', [
		'labels'                => [
			'name'          => \__( 'Wiki', 'nisje' ),
			'singular_name' => \__( 'Wiki', 'nisje' ),
		],
		'public'                => true,
		'publicly_queryable'    => true,
		'exclude_from_search'   => false,
		'show_in_admin_bar'     => false,
		'show_in_nav_menus'     => false,
		'can_export'            => false,
		'show_ui'               => true,
		'query_var'             => false,
		'has_archive'           => false,
		'rewrite'               => [
			'slug'       => 'wiki/%post_id%',
			'with_front' => false,
		],
		'capability_type'       => CAP,
		'capabilities'          => [
			'create_posts'     => 'create_' . CAP . 's',
			'delete_posts'     => 'delete_' . CAP . 's',
			'upload_files_cpt' => 'upload_files_' . CAP,
		],
		'map_meta_cap'          => true,
		'hierarchical'          => false,
		'menu_position'         => null,
		'menu_icon'             => 'dashicons-media-text',
		'supports'              => [
			'author',
			'title',
			'revisions',
			'editor',
			'thumbnail',
			'excerpt',
			'page-attributes',
		],
		'show_in_rest'          => true,
		'rest_base'             => REST,
		'rest_controller_class' => 'WP_REST_Posts_Controller',
		'show_in_graphql'       => true,
		'graphql_single_name'   => GRAPHQL,
		'graphql_plural_name'   => GRAPHQL_PLURAL,
	] );

	\register_post_type( NAME, $args );
}
\add_action( 'init', __NAMESPACE__ . '\\register_post_type' );

/**
 * Add feed post types.
 *
 * @param array $post_types Current Post Types.
 * @return array $post_types Populated Post Types.
 */
function add_feed_post_types( array $post_types ): array {
	$post_types[] = NAME;
	return $post_types;
}
\add_filter( 'nisje_feed_post_types', __NAMESPACE__ . '\\add_feed_post_types' );
