<?php
/**
 * Digest
 *
 * @package Nisje
 */

namespace Nisje\Extension\Digest;

/**
 * Register rest route
 */
function register_routes(): void {
	require __DIR__ . '/class-digest.php';
	$controller = new Rest\Digest();
	$controller->register_routes();

	require __DIR__ . '/class-members.php';
	$controller = new Rest\Members();
	$controller->register_routes();
}
\add_action( 'rest_api_init', __NAMESPACE__ . '\\register_routes' );

/**
 * Register user meta
 */
function register_user_meta(): void {
	\register_meta( 'user', 'nisje_digest_schedule', [
		'sanitize_callback' => function( $meta_value ) {
			if ( ! in_array( $meta_value, [ 'never', 'daily', 'weekly' ], true ) ) {
				$meta_value = 'never';
			}

			return $meta_value;
		},
		'auth_callback'     => function( $allowed, $meta_key, $post_id, $user_id ) {
			return \bp_loggedin_user_id() === $user_id;
		},
		'type'              => 'string',
		'description'       => '',
		'single'            => true,
		'show_in_rest'      => [
			'schema' => [
				'context' => [ 'edit' ],
			],
		],
	] );
}
\add_action( 'init', __NAMESPACE__ . '\\register_user_meta' );

/**
 * Add settings
 *
 * @param array $settings Settings.
 */
function add_settings( array $settings ): array {
	if ( \is_user_logged_in() ) {
		$settings['digest'] = \get_user_meta( \get_current_user_id(), 'nisje_digest_schedule', true ) ?: 'never';
	}

	return $settings;
}
\add_filter( 'nisje_frontend_options', __NAMESPACE__ . '\\add_settings' );
