<?php
/**
 * Wiki Settings.
 *
 * @package Nisje
 */

declare( strict_types = 1 );
namespace Nisje\Extension\Wiki\Settings;

use function Nisje\Extension\Wiki\Utils\{
	get_title,
	get_slug
};

/**
 * Add settings
 *
 * @param array $settings Settings.
 */
function add_settings( array $settings ): array {
	$settings['wikiTitle'] = get_title();
	$settings['wikiSlug']  = get_slug();

	if ( \is_user_logged_in() ) {
		$user_id = \get_current_user_id();
		$user    = \get_userdata( $user_id );

		$settings['userCapabilities']['edit']['wiki']   = $user->allcaps['edit_di_wiki'] ?? false;
		$settings['userCapabilities']['create']['wiki'] = $user->allcaps['create_di_wikis'] ?? false;
	}

	return $settings;
}
\add_filter( 'nisje_frontend_options', __NAMESPACE__ . '\\add_settings' );
