<?php
/**
 * Extensions
 *
 * @package Nisje
 */

declare( strict_types = 1 );
namespace Nisje\Extensions;

\add_filter( 't2/blocks/available', __NAMESPACE__ . '\\register_available_blocks' );

/**
 * Register extensions
 */
if ( function_exists( 'T2\Extensions\register_extension' ) ) {
	foreach ( glob( NISJE_CORE_DIR_PATH . 'extensions/*', GLOB_ONLYDIR ) as $dir ) {
		\T2\Extensions\register_extension( 'nisje/' . basename( $dir ), "$dir/extension.php" );
	}
}

/**
 * Register block library
 *
 * @param array $available Available Blocks.
 * @return array Block library
 */
function register_available_blocks( array $available ): array {
	foreach ( glob( __DIR__ . '/blocks/*', GLOB_ONLYDIR ) as $dir ) {
		$available[ 't2/' . basename( $dir ) ] = "$dir/block.php";
	}

	return $available;
}
