<?php
/**
 * Setup Group news Post Type
 *
 * @package Nisje
 */

namespace Nisje\Extension\News\Groups\PostType;

use const Nisje\Extension\News\Groups\GROUP_META_KEY;
use const Nisje\Constants\GROUP_POST_CAP;
use function Nisje\GroupConnection\Utils\{
	add_frontend_capability,
	add_group_connection_meta,
	add_group_feature,
	get_default_post_type_args
};

const NAME         = 'nisje-news-group';
const REST         = 'nisje-news-group';
const GRAPHQL_NAME = 'groupNews';

/**
 * Add meta connection and frontend caps.
 */
add_group_connection_meta( NAME, GROUP_META_KEY );
add_frontend_capability( 'groupNews' );
add_group_feature(
	'enable_news',
	GROUP_META_KEY,
	__( 'News', 'nisje' ),
	__( 'Enable news articles', 'nisje' )
);

/**
 * Register the Group News post type.
 */
function register_post_type() {
	$args = \apply_filters( 'nisje/news/groups/post_type_args', \wp_parse_args( [
		'labels'              => [
			'name'          => \__( 'Group News', 'nisje' ),
			'singular_name' => \__( 'Group News', 'nisje' ),
		],
		'rewrite'             => [
			'slug'       => 'groups/%group_id%/news/%post_id%',
			'with_front' => false,
		],
		'supports'            => [
			'author',
			'comments',
			'editor',
			'excerpt',
			'revisions',
			'thumbnail',
			'title',
		],
		'menu_icon'           => 'dashicons-megaphone',
		'rest_base'           => REST,
		'graphql_single_name' => GRAPHQL_NAME,
		'graphql_plural_name' => GRAPHQL_NAME . 's',
	], get_default_post_type_args() ) );

	\register_post_type( NAME, $args );
}
\add_action( 'init', __NAMESPACE__ . '\\register_post_type' );

/**
 * Override permissions for group wiki.
 *
 * @param bool   $allowed   Current permission.
 * @param string $post_type Post type.
 */
function override_rest_permission_check( $allowed, $post_type ) {
	if ( NAME === $post_type ) {
		return true;
	}

	return $allowed;
}
\add_filter( 'nisje_override_rest_permission_check', __NAMESPACE__ . '\\override_rest_permission_check', 10, 2 );

