<?php
/**
 * Featured image focal point.
 *
 * @package Nisje
 */

namespace Nisje\FeaturedImage\Utils;

use const T2\Extensions\Library\FeaturedMediaFocalPoint\MATE_KEY;
use function T2\Extensions\Library\FeaturedMediaFocalPoint\get_focal_point;

\add_action( 'graphql_register_types', function() {
	\register_graphql_object_type(
		'FocalPoint',
		[
			'description' => 'Focal point for a featured image',
			'fields'      => [
				'x' => [
					'type'        => 'String',
					'description' => 'x axis',
				],
				'y' => [
					'type'        => 'String',
					'description' => 'y axis',
				],
			],
		]
	);

	\register_graphql_field( 'NodeWithFeaturedImage', 'featuredImageFocalPoint', [
		'type'    => 'FocalPoint',
		'resolve' => function( $source ) {
			if ( \function_exists( 'T2\Extensions\Library\FeaturedMediaFocalPoint\get_focal_point' ) ) {
				return get_focal_point( $source->databaseId ); // phpcs:ignore
			}

			return [
				'x' => '50%',
				'y' => '50%',
			];
		},
	] );
} );
