<?php
/**
 * Digest
 *
 * @package Nisje
 */

namespace Nisje\Extension\Digest;

use function Nisje\Utils\encrypt_decrypt;

/**
 * Register rest route
 */
function register_routes(): void {
	require __DIR__ . '/class-digest.php';
	$controller = new Rest\Digest();
	$controller->register_routes();

	require __DIR__ . '/class-members.php';
	$controller = new Rest\Members();
	$controller->register_routes();

	require __DIR__ . '/class-unsubscribe.php';
	$controller = new Rest\Unsubscribe();
	$controller->register_routes();
}
\add_action( 'rest_api_init', __NAMESPACE__ . '\\register_routes' );

/**
 * Register user meta
 */
function register_user_meta(): void {
	\register_meta( 'user', 'nisje_digest_schedule', [
		'sanitize_callback' => function( $meta_value ) {
			if ( ! in_array( $meta_value, [ 'never', 'daily', 'weekly' ], true ) ) {
				$meta_value = 'never';
			}

			return $meta_value;
		},
		'auth_callback'     => function( $allowed, $meta_key, $post_id, $user_id ) {
			return \bp_loggedin_user_id() === $user_id;
		},
		'type'              => 'string',
		'description'       => '',
		'single'            => true,
		'show_in_rest'      => [
			'schema' => [
				'context' => [ 'edit' ],
			],
		],
	] );
}
\add_action( 'init', __NAMESPACE__ . '\\register_user_meta' );

/**
 * Add settings
 *
 * @param array $settings Settings.
 */
function add_settings( array $settings ): array {
	if ( \is_user_logged_in() ) {
		$settings['digest'] = \get_user_meta( \get_current_user_id(), 'nisje_digest_schedule', true ) ?: 'never';
	}

	return $settings;
}
\add_filter( 'nisje_frontend_options', __NAMESPACE__ . '\\add_settings' );

/**
 * Add editor assets
 */
function assets(): void {
	$asset_file = NISJE_CORE_DIR_PATH . 'extensions/digest/build/index.asset.php';

	if ( ! \file_exists( $asset_file ) ) {
		return;
	}

	$asset        = require_once $asset_file;
	$dependencies = isset( $asset['dependencies'] ) ? $asset['dependencies'] : [];
	$version      = isset( $asset['version'] ) ? $asset['version'] : filemtime( $path );

	\wp_enqueue_script(
		'nisje-extension-digest',
		NISJE_CORE_URL . 'extensions/digest/build/index.js',
		$dependencies,
		$version,
		true
	);

	\wp_add_inline_script(
		'nisje-extension-digest',
		sprintf(
			'var nisjeUnsubscribeKey = "%s"; var nisjeUnsubscribeEmail = %s;',
			\wp_unslash( $_GET['digest-unsubscribe'] ), // phpcs:ignore
			encrypt_decrypt( 'decrypt', \wp_unslash( $_GET['digest-unsubscribe'] ) ) // phpcs:ignore
		),
		'before'
	);
}

/**
 * Template
 *
 * @param null|string $template Template path.
 * @return null|string Template path
 */
function template( ?string $template ) : ?string {
	if ( isset( $_GET['digest-unsubscribe'] ) && ! empty( $_GET['digest-unsubscribe'] ) ) { // phpcs:ignore
		\remove_action( 'wp_enqueue_scripts', 'NisjeFrontend\ClientAssets\register_scripts_and_styles' );
		\remove_action( 'wp_enqueue_scripts', 'NisjeFrontend\ClientAssets\enqueue_styles_and_scripts' );
		\remove_action( 'wp_enqueue_scripts', 'NisjeFrontend\ClientAssets\register_packages_scripts' );
		\remove_action( 'wp_body_open', 'NisjeFrontend\Setup\add_skip_link' );
		\add_action( 'wp_enqueue_scripts', __NAMESPACE__ . '\\assets' );
		$template = __DIR__ . '/templates/unsubscribe.php';
		return $template;
	}

	return $template;
}
\add_filter( 'template_include', __NAMESPACE__ . '\\template', 20 );
