<?php
/**
 * Wiki Group Rest API.
 *
 * @package Nisje
 */

declare( strict_types = 1 );
namespace Nisje\Extension\Wiki\Groups\Rest;

use const Nisje\Extension\Wiki\Groups\PostType\NAME as POST_TYPE_NAME;

/**
 * Extend rest types.
 *
 * @param array $post_types Current Post Types.
 * @return array $post_types Populated Post Types.
 */
function add_shared_rest_fields( array $post_types ): array {
	$post_types[] = POST_TYPE_NAME;
	return $post_types;
}
\add_filter( 'nisje_rest_shared_fields_group_post_types', __NAMESPACE__ . '\\add_shared_rest_fields' );
