<?php
/**
 * Comments open graphql
 *
 * @package Nisje
 */

namespace Nisje\GraphQL\CommentsOpen;

\add_action( 'graphql_register_types', __NAMESPACE__ . '\\extend_wpgraphql_schema' );

/**
 * Extend WPGraphQL schema
 */
function extend_wpgraphql_schema() {
	\register_graphql_field( 'RootQuery', 'commentsOpen', [
		'type'    => 'Boolean',
		'args'    => [
			'id' => [
				'type'        => 'ID',
				'description' => 'Object id',
			],
		],
		'resolve' => function( $source, $args ) {
			if ( isset( $args['id'] ) ) {
				return \comments_open( $args['id'] );
			}

			return null;
		},
	] );
}
