<?php
/**
 * Plugin Name: Nisje Community
 * Description: Core Community functionality. The mothership
 * Author:      Dekode
 * Author URI:  https://dekode.no/en/
 * Version:     9.7.5
 * Update URI:  false
 * Text Domain: nisje
 * License:     GPLv2 or later (license.txt)
 *
 * @package Nisje
 */

declare( strict_types = 1 );

define( 'NISJE_CORE_DIR_PATH', \plugin_dir_path( __FILE__ ) );
define( 'NISJE_CORE_URL', \plugin_dir_url( __FILE__ ) );
define( 'NISJE_CORE_VERSION', '9.7.5' );
define( 'NISJE_CORE_DB_VERSION', '0.0.12' );

/**
 * Returns the instance of Nisje to functions everywhere.
 *
 * @return Nisje|null The object.
 */
function nisje() {
	return Dekode\Nisje\Core::instance();
}

require __DIR__ . '/constants.php';
require __DIR__ . '/utils/utils.php';
require __DIR__ . '/class-core.php';
require __DIR__ . '/includes/extensions.php';
require __DIR__ . '/includes/optimizations.php';
require __DIR__ . '/includes/helpers/helper-functions.php';
require __DIR__ . '/graphql/reactions.php';
require __DIR__ . '/graphql/comments-open.php';
require __DIR__ . '/graphql/featured-image-focal-point.php';
require __DIR__ . '/utils/group-connection/index.php';
// require __DIR__ . '/includes/buddypress/archive-group.php'; // phpcs:ignore.

$GLOBALS['nisje'] = nisje();

/**
 * Active plugin dependencies
 */
\add_action( 'plugins_loaded', function() {
	if ( ! defined( 'T2_VERSION' ) ) {
		require_once ABSPATH . '/wp-admin/includes/plugin.php';
		\activate_plugins( [ 't2/t2.php' ] );
	}

	if ( ! class_exists( 'WPGraphQL' ) ) {
		require_once ABSPATH . '/wp-admin/includes/plugin.php';
		\activate_plugins( [ 'wp-graphql/wp-graphql.php' ] );
	}
} );
