<?php
/**
 * Setup News Categories
 *
 * @package Nisje
 */

namespace Nisje\Extension\News\Taxonomy;

use const Nisje\Extension\News\PostType\{
	NAME as POST_TYPE_NAME,
	CAP
};

const NAME           = 'dekode-news-category';
const REST           = 'dekode-news-categories';
const GRAPHQL        = 'newsCategory';
const GRAPHQL_PLURAL = 'newsCategories';

/**
 * Register the News taxonomy.
 */
function register_taxonomy() {
	$args = [
		'labels'                => [
			'name'              => \_x( 'Categories', 'taxonomy general name', 'nisje' ),
			'singular_name'     => \_x( 'Category', 'taxonomy singular name', 'nisje' ),
			'search_items'      => \__( 'Search categories', 'nisje' ),
			'all_items'         => \__( 'All categories', 'nisje' ),
			'parent_item'       => \__( 'Parent', 'nisje' ),
			'parent_item_colon' => \__( 'Parent:', 'nisje' ),
			'edit_item'         => \__( 'Edit', 'nisje' ),
			'update_item'       => \__( 'Update', 'nisje' ),
			'add_new_item'      => \__( 'Add New Category', 'nisje' ),
			'new_item_name'     => \__( 'Category Name', 'nisje' ),
			'menu_name'         => \__( 'Categories', 'nisje' ),
		],
		'hierarchical'          => true,
		'show_admin_column'     => true,
		'show_ui'               => true,
		'query_var'             => true,
		'rewrite'               => false,
		'capability_type'       => CAP,
		'capabilities'          => [],
		'show_in_rest'          => true,
		'rest_base'             => REST,
		'rest_controller_class' => 'WP_REST_Terms_Controller',
		'show_in_graphql'       => true,
		'graphql_single_name'   => GRAPHQL,
		'graphql_plural_name'   => GRAPHQL_PLURAL,
	];

	\register_taxonomy( NAME, POST_TYPE_NAME, $args );
}

\add_action( 'init', __NAMESPACE__ . '\\register_taxonomy' );
