<?php
/**
 * Setup General Settings.
 *
 * @package Nisje
 */

defined( 'ABSPATH' ) || die( 'Shame on you' );

$field_key_prefix = nisje_get_setting( 'field_key_prefix', 'general' );

acf_add_local_field_group(
	[
		'key'                   => $field_key_prefix . '_general_group',
		'title'                 => esc_html__( 'General options', 'nisje' ),
		'fields'                => [
			[
				'key'       => $field_key_prefix . '_general_tab_general',
				'label'     => esc_html__( 'General', 'nisje' ),
				'name'      => '',
				'type'      => 'tab',
				'placement' => 'left',
				'endpoint'  => 0,
			],
			[
				'key'   => $field_key_prefix . '_community_id',
				'label' => esc_html__( 'Community ID', 'nisje' ),
				'name'  => $field_key_prefix . '_community_id',
				'type'  => 'text',
			],
			[
				'key'   => $field_key_prefix . '_tracking_id',
				'label' => esc_html__( 'Google Analytics ID', 'nisje' ),
				'name'  => $field_key_prefix . '_tracking_id',
				'type'  => 'text',
			],
			[
				'key'       => $field_key_prefix . '_tab_login_registration',
				'label'     => esc_html__( 'Login/Registration', 'nisje' ),
				'name'      => '',
				'type'      => 'tab',
				'placement' => 'left',
				'endpoint'  => 0,
			],
			[
				'key'          => $field_key_prefix . '_exclude_members',
				'label'        => esc_html__( 'Exclude members', 'nisje' ),
				'name'         => $field_key_prefix . '_exclude_members',
				'type'         => 'user',
				'instructions' => esc_html__( 'You can exclude members from showing. Add members you want to exclude', 'nisje' ),
				'role'         => '',
				'allow_null'   => 0,
				'multiple'     => 1,
			],
			[
				'key'   => $field_key_prefix . '_login_info_message',
				'label' => esc_html__( 'Login info message', 'nisje' ),
				'name'  => $field_key_prefix . '_login_info_message',
				'type'  => 'text',
				'role'  => '',
			],
			[
				'key'          => $field_key_prefix . '_terms',
				'label'        => esc_html__( 'Terms and conditions', 'nisje' ),
				'name'         => $field_key_prefix . '_terms',
				'type'         => 'wysiwyg',
				'instructions' => esc_html__( 'Add the terms and conditions content to show at registration', 'nisje' ),
				'role'         => '',
			],
			[
				'key'       => $field_key_prefix . '_tab_mail',
				'label'     => esc_html__( 'Mail', 'nisje' ),
				'name'      => '',
				'type'      => 'tab',
				'placement' => 'left',
				'endpoint'  => 0,
			],
			[
				'key'           => $field_key_prefix . '_mail_from',
				'label'         => esc_html__( 'Public address for all outgoing e-mails.', 'nisje' ),
				'name'          => $field_key_prefix . '_mail_from',
				'type'          => 'email',
				'default_value' => '',
				'placeholder'   => esc_html__( 'Ex: intranet@dekode.no', 'nisje' ),
			],
			[
				'key'           => $field_key_prefix . '_mail_from_name',
				'label'         => esc_html__( 'Public name for all outgoing e-mails.', 'nisje' ),
				'name'          => $field_key_prefix . '_mail_from_name',
				'type'          => 'text',
				'default_value' => '',
				'placeholder'   => esc_html__( 'Ex: Intranet', 'nisje' ),
			],
		],
		'location'              => [
			[
				[
					'param'    => 'options_page',
					'operator' => '==',
					'value'    => nisje_get_setting( 'settings_key', 'core' ),
				],
			],
		],
		'menu_order'            => 0,
		'position'              => 'normal',
		'style'                 => 'default',
		'label_placement'       => 'top',
		'instruction_placement' => 'label',
		'hide_on_screen'        => '',
		'active'                => 1,
		'description'           => '',
	]
);
