<?php
/**
 * Setup Consent Post Type
 *
 * @package Nisje
 */

namespace Nisje\Extension\Consent\PostType;

const NAME           = 'consents';
const REST           = 'consents';
const GRAPHQL        = 'consent';
const GRAPHQL_PLURAL = 'consents';
const TRANSIENT      = 'consent_id';

/**
 * Register the Consent post type.
 */
function register_post_type() {
	\register_post_type( NAME, [
		'labels'                => [
			'name'          => \__( 'Consents', 'nisje' ),
			'singular_name' => \__( 'Consent', 'nisje' ),
		],
		'public'                => false,
		'publicly_queryable'    => true,
		'exclude_from_search'   => true,
		'show_in_admin_bar'     => false,
		'show_in_nav_menus'     => false,
		'can_export'            => false,
		'show_ui'               => true,
		'query_var'             => false,
		'has_archive'           => false,
		'hierarchical'          => false,
		'menu_position'         => null,
		'menu_icon'             => 'dashicons-megaphone',
		'supports'              => [
			'title',
			'revisions',
			'editor',
			'custom-fields',
		],
		'show_in_rest'          => true,
		'rest_base'             => REST,
		'rest_controller_class' => 'WP_REST_Posts_Controller',
		'show_in_graphql'       => true,
		'graphql_single_name'   => GRAPHQL,
		'graphql_plural_name'   => GRAPHQL_PLURAL,
	] );
}
\add_action( 'init', __NAMESPACE__ . '\\register_post_type' );

/**
 * Delete transient key on post save.
 */
function delete_consent_transient() {
	\delete_transient( TRANSIENT );
}
\add_action( 'save_post_' . NAME, __NAMESPACE__ . '\\delete_consent_transient' );
