<?php
/**
 * Load consent template
 *
 * @package Nisje
 */

namespace Nisje\Extension\Consent\Template;

use const Nisje\Extension\Consent\PostType\NAME as POST_TYPE_NAME;
use const Nisje\Extension\Consent\PostType\TRANSIENT;

/**
 * Include plugin components
 */
function template() {
	if ( is_user_logged_in() && ! is_admin() ) {
		$consent_id = \get_transient( TRANSIENT );

		if ( false === $consent_id ) {
			// It wasn't there, grab the latest post and save it to a transient.
			$latest_cpt = \get_posts( 'post_type=' . POST_TYPE_NAME . '&numberposts=1' );

			if ( empty( $latest_cpt ) ) {
				return;
			}

			$consent_id = $latest_cpt[0]->ID;
			\set_transient( TRANSIENT, $consent_id );
		}

		$meta_key     = 'consent_accepted_' . $consent_id;
		$user_id      = \get_current_user_id();
		$has_accepted = \get_user_meta( $user_id, $meta_key, true );

		if ( empty( $has_accepted ) || ! $has_accepted ) {
			$nonce_key   = 'nisje-consent';
			$nonce_check = isset( $_REQUEST['_wpnonce'] ) && wp_verify_nonce( $_REQUEST['_wpnonce'], $nonce_key ); // phpcs:ignore

			if ( $nonce_check && isset( $_REQUEST['accept'] ) ) {
				\update_user_meta( $user_id, $meta_key, true );
			} else {
				$the_query = new \WP_Query( [
					'post_type' => POST_TYPE_NAME,
					'post__in'  => [ $consent_id ],
				] );

				if ( $the_query->have_posts() ) {
					$style_path = \get_stylesheet_directory_uri();
					?>
					<html <?php \language_attributes(); ?>>
						<head>
							<meta charset="<?php bloginfo( 'charset' ); ?>" />
							<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
							<title><?php echo get_bloginfo( 'name' ); // phpcs:ignore ?></title>
							<?php // phpcs:disable ?>
							<link rel="stylesheet" href="<?php echo $style_path; ?>/build/sanitize/style.css" type="text/css" media="all" />
							<link rel="stylesheet" href="<?php echo $style_path; ?>/build/settings/style.css" type="text/css" media="all" />
							<link rel="stylesheet" href="<?php echo $style_path; ?>/build/wordpress/privacy.css" type="text/css" media="all" />
							<link rel="stylesheet" href="<?php echo $style_path; ?>/assets/fonts/circular/style.css" type="text/css" media="all" />
							<?php // phpcs:enable ?>
						</head>
						<body>
							<div class="privacy-wrapper">
								<?php
								while ( $the_query->have_posts() ) {
									$the_query->the_post();
									the_title( '<h1>', '</h1>' );
									the_content();
								}
								?>
							</div>
							<div class="privacy-accept">
								<div class="privacy-accept-content">
									<a href="<?php echo esc_url( wp_nonce_url( add_query_arg( 'accept', 'true' ), $nonce_key ) ); ?>" class="privacy-accept-button"><?php esc_html_e( 'Accept', 'nisje' ); ?></a>
								</div>
							</div>
						</body>
					</html>
					<?php
					exit;
				}

				/* Restore original Post Data */
				wp_reset_postdata();
			}
		}
	}
}
\add_action( 'parse_request', __NAMESPACE__ . '\\template' );
