<?php
/**
 * Nisje Digest Rest API.
 *
 * @package Nisje
 */

declare( strict_types = 1 );
namespace Nisje\Extension\Digest\Rest;

use function Nisje\Utils\encrypt_decrypt;

/**
 * Create Nisje Digest rest api endpoint.
 */
class Unsubscribe extends \WP_REST_Controller {
	/**
	 * Register the routes for the objects of the controller.
	 */
	public function register_routes(): void {
		$namespace = 'nisje/v1';
		$base      = 'digest-unsubscribe';

		\register_rest_route( $namespace, '/' . $base, [
			[
				'methods'             => \WP_REST_Server::CREATABLE,
				'callback'            => [ $this, 'get_item' ],
				'permission_callback' => '__return_true',
				'args'                => [
					'context' => [
						'default' => 'view',
					],
				],
			],
		] );
	}

	/**
	 * Get one item from the collection
	 *
	 * @param \WP_REST_Request $request Full data about the request.
	 * @return \WP_Error|\WP_REST_Response
	 */
	public function get_item( $request ): \WP_REST_Response { // phpcs:ignore
		$email = $request->get_param( 'email' );
		$key   = $request->get_param( 'key' );

		$data = encrypt_decrypt( 'decrypt', $key );

		$data = (array) json_decode( $data );

		if ( empty( $email ) ) {
			return new \WP_REST_Response( [
				'message' => 'Missing email',
			], 400 );
		} elseif ( empty( $key ) ) {
			return new \WP_REST_Response( [
				'message' => 'Missing key',
			], 400 );
		} elseif ( ! \is_email( $email ) ) {
			return new \WP_REST_Response( [
				'message' => 'Invalid email',
			], 400 );
		} elseif ( $data['email'] !== $email ) {
			return new \WP_REST_Response( [
				'message' => 'Invalid key',
			], 400 );
		}

		\update_user_meta( $data['id'], 'nisje_digest_schedule', 'never' );

		return new \WP_REST_Response( $email, 200 );
	}

	/**
	 * Prepare the item for the REST response
	 *
	 * @param mixed            $items   WordPress representation of the item.
	 * @param \WP_REST_Request $request Request object.
	 * @return mixed
	 */
	public function prepare_item_for_response( $items, $request ) { // phpcs:ignore
		return $items;
	}
}
