/**
 * External dependencies
 */
import { render } from 'react-dom';
import apiFetch from '@wordpress/api-fetch';
import { useState } from 'react';

/**
 * Nisje dependencies
 */
import { ThemeProvider } from '@emotion/react';
import styled from '@emotion/styled';

const Container = styled.div`
	text-align: center;
	font-family: Helvetica, Arial, Calibri, sans-serif;
	padding: 3rem 0;

	& p a {
		color: #00579e;
	}
`;

const Button = styled.a`
	display: inline-block;
	background-color: transparent;
	border: 2px solid #00579e;
	font-weight: 600;
	border-radius: 4px;
	padding: 1rem 2rem;
	line-height: 1;
	font-size: 1rem;
	text-decoration: none;
	color: #333;
	cursor: pointer;
	margin: 2rem 0.5rem;
`;

const UnsubButton = styled(Button)`
	background-color: #00579e;
	color: #fff;
`;

function App() {
	const [isUnsubscribed, setIsUnsubscribed] = useState(false);
	const [errorMessage, setError] = useState('');

	const handleUnsubscribe = () => {
		apiFetch({
			path: '/nisje/v1/digest-unsubscribe',
			method: 'POST',
			data: {
				email: window.nisjeUnsubscribeEmail.email,
				id: window.nisjeUnsubscribeEmail.id,
				key: window.nisjeUnsubscribeKey,
			},
		})
			.then(() => {
				setIsUnsubscribed(true);
			})
			.catch((err) => {
				setError(err.message);
			});
	};

	if (errorMessage) {
		return (
			<Container>
				<h1>Something went wrong</h1>
				<p>{errorMessage}</p>
			</Container>
		);
	}

	if (!window?.nisjeUnsubscribeEmail?.email) {
		return (
			<Container>
				<h1>Something went wrong</h1>
				<p>Please contact an administrator to unsubscribe</p>
			</Container>
		);
	}

	if (isUnsubscribed) {
		return (
			<Container>
				<h1>You are now unsubscribed</h1>
				<UnsubButton href="/">Back to homepage</UnsubButton>
			</Container>
		);
	}

	return (
		<Container>
			<h1>Do you want to unsubscribe?</h1>
			<p>
				If you unsubscribe you will stop sending summary emails to{' '}
				<a href={`mailto:${window.nisjeUnsubscribeEmail.email}`}>
					{window.nisjeUnsubscribeEmail.email}
				</a>
			</p>
			<UnsubButton as="button" type="button" onClick={handleUnsubscribe}>
				Unsubscribe
			</UnsubButton>
			<Button href="/">Cancel</Button>
		</Container>
	);
}

/**
 * Render
 */
render(
	<ThemeProvider theme={{}}>
		<App />
	</ThemeProvider>,
	document.getElementById('root'),
);
