/**
 * External dependencies
 */
import { isEmpty } from 'lodash';

/**
 * WordPress dependencies
 */
import { hasQueryArg, getQueryArg } from '@wordpress/url';
import { store as editorStore } from '@wordpress/editor';
import { registerPlugin } from '@wordpress/plugins';
import { useSelect, useDispatch } from '@wordpress/data';
import { store as coreStore } from '@wordpress/core-data';
import { useEffect } from '@wordpress/element';

function SetCategory() {
	const { editPost } = useDispatch(editorStore);
	const { taxonomies, postType } = useSelect((select) => {
		return {
			postType: select(editorStore).getCurrentPostType(),
			taxonomies: select(coreStore).getTaxonomies({
				per_page: -1,
			}),
		};
	});

	useEffect(() => {
		if (postType && !isEmpty(taxonomies)) {
			const URL = window.location.href;
			const supportedTaxonomies = taxonomies.filter((taxonomy) =>
				taxonomy.types.includes(postType),
			);

			supportedTaxonomies.forEach((taxonomy) => {
				if (hasQueryArg(URL, taxonomy.rest_base)) {
					const id = parseInt(
						getQueryArg(URL, taxonomy.rest_base),
						10,
					);
					editPost({
						[taxonomy.rest_base]: [id],
					});
				}
			});
		}
	}, [taxonomies, postType]);

	return null;
}

registerPlugin('nisje-set-category', {
	icon: null,
	render() {
		const isNew = useSelect((select) =>
			select(editorStore).isEditedPostNew(),
		);

		if (isNew) {
			return <SetCategory />;
		}

		return null;
	},
});
