<?php
/**
 * Utils.
 *
 * @package Nisje
 */

namespace Nisje\Utils;

/**
 * Get term count
 *
 * @param string $taxonomy Taxonomy name.
 * @param mixed  $term     Term ID.
 */
function get_term_post_count( string $taxonomy = 'category', $term = '' ) {
	if ( ! $term ) {
		return 0;
	}

	if ( 'all' !== $term ) {
		if ( ! is_array( $term ) ) {
			$term = filter_var( $term, FILTER_VALIDATE_INT );
		} else {
			$term = filter_var_array( $term, FILTER_VALIDATE_INT );
		}
	}

	if ( 'category' !== $taxonomy ) {
		$taxonomy = filter_var( $taxonomy, FILTER_SANITIZE_STRING );

		if ( ! taxonomy_exists( $taxonomy ) ) {
			return 0;
		}
	}

	$args = [
		'posts_per_page' => 1,
		'fields'         => 'ids',
		'tax_query'      => [ // phpcs:ignore
			[
				'taxonomy' => $taxonomy,
				'terms'    => $term,
			],
		],
	];

	$q = new \WP_Query( $args );
	return $q->found_posts;
}

/**
 * Check if string end with a substring.
 *
 * @param string $haystack String to search in.
 * @param string $needle   String to search for.
 */
function string_ends_with( string $haystack, string $needle ): bool {
	$length = strlen( $needle );

	if ( ! $length ) {
		return true;
	}

	return substr( $haystack, -$length ) === $needle;
}

/**
 * Simple function to encrypt or decrypt a plain text string.
 *
 * @param string $action  Encrypt or decrypt.
 * @param string $string  String to encrypt or decrypt.
 */
function encrypt_decrypt( string $action, string $string ): string {
	$output         = '';
	$encrypt_method = 'AES-256-CBC';
	$secret_key     = 'WHxw2BiwhymoRd_82UAb*-QdMVNZv*Wa@!y';
	$secret_iv      = 'usQeorFRpesqn68F!TF9s9yiBG4ZNcZeFQu';
	$key            = hash( 'sha256', $secret_key );
	$iv             = substr( hash( 'sha256', $secret_iv ), 0, 16 );
	if ( 'encrypt' === $action ) {
		$output = openssl_encrypt( $string, $encrypt_method, $key, 0, $iv );
		$output = base64_encode( $output ); // phpcs:ignore WordPress.PHP.DiscouragedPHPFunctions.obfuscation_base64_encode
	} elseif ( 'decrypt' === $action ) {
		$output = openssl_decrypt( base64_decode( $string ), $encrypt_method, $key, 0, $iv ); // phpcs:ignore WordPress.PHP.DiscouragedPHPFunctions.obfuscation_base64_decode
	}
	return $output;
}
