<?php
/**
 * Plugin Name: Nisje - Normisjon
 * Description: Functionality for Normisjon
 * Author:      Dekode
 * Author URI:  https://dekode.no/en/
 * Version:     7.7.4
 * Text Domain: nisje-normisjon
 * Domain Path: /languages/
 * License:     GPLv2 or later (license.txt)
 *
 * @package Nisje
 */

declare( strict_types = 1 );
defined( 'ABSPATH' ) || die( 'Shame on you' );

define( 'NISJE_NORMISJON_VERSION', '7.7.4' );

/**
 * Load plugin textdomain.
 */
function nisje_normisjon_load_textdomain() {
	load_plugin_textdomain( 'nisje-normisjon', false, basename( __DIR__ ) . '/languages' );
}
add_action( 'plugins_loaded', 'nisje_normisjon_load_textdomain' );

/**
 * Include plugin components
 */
function nisje_normisjon_include() {
	require __DIR__ . '/event/event.php';
}
add_action( 'nisje_include', 'nisje_normisjon_include', 11 );

/**
 * Registers scripts and styles
 */
function nisje_normisjon_register_scripts_and_styles() {
	wp_enqueue_script( 'nisje-plugin-normisjon' );
}
add_action( 'wp_enqueue_scripts', 'nisje_normisjon_register_scripts_and_styles', 20 );
