<?php
/**
 * Setup Event Type
 *
 * @package Nisje
 */

declare( strict_types=1 );
defined( 'ABSPATH' ) || die( 'Shame on you' );

$cap = nisje_get_setting( 'capability_key', 'event' );

$args = apply_filters( 'nisje_event_taxonomy_event_type_args', [
	'labels'                => [
		'name'          => esc_html_x( 'Type', 'taxonomy general name', 'nisje-normisjon' ),
		'singular_name' => esc_html_x( 'Type', 'taxonomy singular name', 'nisje-normisjon' ),
		'menu_name'     => esc_html__( 'Type', 'nisje-normisjon' ),
		'add_new_item'  => esc_html__( 'Add Type', 'nisje-normisjon' ),
	],
	'hierarchical'          => true,
	'show_admin_column'     => true,
	'show_ui'               => true,
	'query_var'             => false,
	'rewrite'               => false,
	'capability_type'       => $cap,
	'capabilities'          => [
		'assign_terms' => "create_{$cap}s",
	],
	'show_in_rest'          => true,
	'rest_base'             => 'nisje-event-type',
	'rest_controller_class' => 'WP_REST_Terms_Controller',
] );

$object_type = apply_filters( 'nisje_event_type_object_types', [ nisje_get_setting( 'post_type_name', 'event' ) ] );

register_taxonomy( 'nisje-event-type', $object_type, $args );
