<?php
/**
 * Extend Settings Endpoint
 *
 * @package Nisje
 */

declare( strict_types = 1 );

// Add Guest User to Open Community Settings.
register_rest_field( 'settings', 'open_community', [
	'get_callback' => function() : array {
		$guest_user = (array) nisje_get_setting( 'guest_user', 'open_community' );
		if ( is_array( $guest_user ) && ! empty( $guest_user ) ) {
			return $guest_user;
		} else {
			return [];
		}
	},
	'schema'       => [
		'context'     => [ 'view' ],
		'description' => esc_html__( 'Open Community', 'nisje-open-community' ),
		'type'        => 'array',
		'items'       => [
			'type' => 'mixed',
		],
		'readonly'    => true,
	],
] );
