<?php
/**
 * Plugin Name: Nisje - Open Community
 * Description: Feature that automatically logs in the user when they visit the home URL, bypassing the default login screen. Requires specified guest user in the Nisje settings panel.
 * Author:      Dekode
 * Author URI:  https://dekode.no/en/
 * Version:     7.2.1
 * Text Domain: nisje-open-community
 * Domain Path: /languages/
 * License:     GPLv2 or later (license.txt)
 *
 * @package Nisje
 */

declare( strict_types = 1 );
defined( 'ABSPATH' ) || die( 'Shame on you' );

define( 'NISJE_OPEN_COMMUNITY_VERSION', '7.2.1' );

/**
 * Load plugin textdomain.
 */
function nisje_open_community_load_textdomain() {
	load_plugin_textdomain( 'nisje-open-community', false, basename( __DIR__ ) . '/languages' );
}
add_action( 'plugins_loaded', 'nisje_open_community_load_textdomain' );

/**
 * Include plugin components
 */
function nisje_open_community_include() {
	require __DIR__ . '/open-community/open-community.php';
}
add_action( 'nisje_include', 'nisje_open_community_include' );

/**
 * Add JWT token to theme
 */
add_action( 'init', function() {
	if ( ! is_user_logged_in() ) {
		add_filter( 'nisje_jwt_token', function( $token ) {
			$user = get_userdata( nisje_open_community_get_guest_user_id() );
			return nisje_jwt_generate_token( $user );
		} );
	}
} );
