<?php
/**
 * Helper functions.
 *
 * @package Nisje
 */

defined( 'ABSPATH' ) || exit;

/**
 * Returns the guest user ID.
 *
 * @return int|false The ID of the guest user set in options, or false on failure.
 */
function nisje_open_community_get_guest_user_id() {
	$guest_user = (array) nisje_get_setting( 'guest_user', 'open_community' );

	if ( is_array( $guest_user ) && ! empty( $guest_user['ID'] ) ) {
		return (int) $guest_user['ID'];
	}
	return false;
}
