<?php
/**
 * Setup Open Community Settings.
 *
 * @package Nisje
 */

declare( strict_types = 1 );

defined( 'ABSPATH' ) || die( 'Shame on you' );

$field_key_prefix = nisje_get_setting( 'field_key_prefix', 'open_community' );

acf_add_local_field_group( [
	'key'                   => $field_key_prefix . '_open_community',
	'title'                 => esc_html__( 'Options Open Community', 'nisje' ),
	'fields'                => [
		[
			'key'           => $field_key_prefix . '_guest_user',
			'label'         => esc_html__( 'Guest user', 'nisje' ),
			'name'          => $field_key_prefix . '_guest_user',
			'type'          => 'user',
			'instructions'  => esc_html__( 'Select the user you wish guests to auto-log-in as.', 'nisje' ),
			'required'      => 0,
			'role'          => '',
			'allow_null'    => 0,
			'multiple'      => 0,
			'return_format' => 'object',
		],
	],
	'location'              => [
		[
			[
				'param'    => 'options_page',
				'operator' => '==',
				'value'    => nisje_get_setting( 'settings_menu_key', 'open_community' ),
			],
		],
	],
	'menu_order'            => 0,
	'position'              => 'normal',
	'style'                 => 'default',
	'label_placement'       => 'top',
	'instruction_placement' => 'label',
	'hide_on_screen'        => '',
	'active'                => 1,
	'description'           => '',
] );
