<?php
/**
 * Plugin Name: Nisje - Redningsselskapet
 * Description: Functionality for Redningsselskapet
 * Author:      Dekode
 * Author URI:  https://dekode.no/en/
 * Version:     5.0.4
 * Text Domain: nisje-rs
 * Domain Path: /languages/
 * License:     GPLv2 or later (license.txt)
 *
 * @package Nisje
 */

declare( strict_types = 1 );
defined( 'ABSPATH' ) || die( 'Shame on you' );

define( 'NISJE_RS_VERSION', '5.0.4' );
define( 'NISJE_RS_URL', plugin_dir_url( __FILE__ ) );

/**
 * Load plugin textdomain.
 */
function nisje_rs_load_textdomain() {
	load_plugin_textdomain( 'nisje-rs', false, basename( __DIR__ ) . '/languages' );
}
add_action( 'plugins_loaded', 'nisje_rs_load_textdomain' );

/**
 * Include plugin components
 */
function nisje_rs_include() {
	// Updates.
	require __DIR__ . '/updates.php';

	// Cards.
	require __DIR__ . '/cards/stat.php';

	// Components.
	require __DIR__ . '/components/rs-retriever/rs-retriever.php';

	// Sync AD.
	require __DIR__ . '/ad/synchronize-ad.php';

	// Forgotten password link.
	require __DIR__ . '/forgotten-password/forgotten-password.php';

	// WP CLI.
	require __DIR__ . '/wp-cli/wp-cli.php';

	// Remove wiki from feed.
	add_action( 'nisje_components_registered', function() {
		if ( function_exists( 'nisje_get_component' ) ) {
			remove_filter( 'nisje_feed_post_types', [ nisje_get_component( 'wiki' ), 'add_feed_post_types' ], 10 );
		}
	} );

	$current_plugin_version = NISJE_RS_VERSION;
	$version_option_key     = 'nisje_rs_version';
	$installed_version      = get_option( $version_option_key );

	// Load NADI login functionality to allow using AD when logging into WordPress.
	$request_uri = filter_input( INPUT_SERVER, 'REQUEST_URI', FILTER_SANITIZE_URL );
	if ( defined( 'NEXT_AD_INT_PREFIX' ) && is_string( $request_uri ) && false !== strpos( $request_uri, '/wp-json/jwt-auth/v1/token' ) ) {
		add_filter( NEXT_AD_INT_PREFIX . 'auth_enable_login_check', '__return_true' );
	}

	// Do nothing if $installed_version is >= $plugin_version.
	if ( ! $installed_version || version_compare( $installed_version, $current_plugin_version, '<=' ) ) {
		add_action( 'init', 'nisje_rs_activation' );
	}

	// Disable notifications ping service because RS server don't allow it.
	add_filter( 'nisje_notification_ping_service_enabled', '__return_false' );
}
add_action( 'nisje_include', 'nisje_rs_include' );
