<?php
/**
 * Synchronize AD.
 *
 * @package Nisje
 */

declare( strict_types=1 );

defined( 'ABSPATH' ) || die( 'Shame on you' );

/**
 * This method is called during the synchronization of attributes
 *
 * @param NextADInt_Adi_User $adi_user        ADI User.
 * @param WP_User            $wp_user         WP User.
 * @param boolean            $sync_wordpress  Sync WordPress.
 * @param boolean            $write_user_meta Write User meta.
 */
function nisje_rs_synchronize_ad( $adi_user, $wp_user, $sync_wordpress, $write_user_meta ) {
	$logger = Logger::getLogger( __CLASS__ );

	$id = (int) $adi_user->getId();

	$ldap_attributes = $adi_user->getLdapAttributes();

	$ldap_attributes_raw = $ldap_attributes->getRaw();

	if ( $id <= 0 ) {
		// only accept valid user id's.
		return;
	}

	if ( ! get_user_meta( $id, 'last_activity', true ) ) {
		update_user_meta( $id, 'last_activity', current_time( 'mysql' ) );
	}

	// Frivillige.
	$group_mappings = [
		'department' => [
			'Region Øst'           => [
				'group_id'    => 8,
				'member_type' => 'frivillige',
			],
			'Region Sør'           => [
				'group_id'    => 7,
				'member_type' => 'frivillige',
			],
			'Region Nord'          => [
				'group_id'    => 4,
				'member_type' => 'frivillige',
			],
			'Region Vest'          => [
				'group_id'    => 6,
				'member_type' => 'frivillige',
			],
			'Region Midt-Norge'    => [
				'group_id'    => 5,
				'member_type' => 'frivillige',
			],
			// Nord.
			'RSRK Alta'            => [
				'group_id'    => 4,
				'member_type' => 'frivillige',
			],
			'RSRK Tromsø'          => [
				'group_id'    => 4,
				'member_type' => 'frivillige',
			],
			'RSRK Harstad'         => [
				'group_id'    => 4,
				'member_type' => 'frivillige',
			],
			'RSRK Brønnøysund'     => [
				'group_id'    => 4,
				'member_type' => 'frivillige',
			],
			// Midt.
			'RSRK Trondheim'       => [
				'group_id'    => 5,
				'member_type' => 'frivillige',
			],
			'RSRK Namsos'          => [
				'group_id'    => 5,
				'member_type' => 'frivillige',
			],
			'RSRK Ålesund'         => [
				'group_id'    => 5,
				'member_type' => 'frivillige',
			],
			'RSRK Aukra'           => [
				'group_id'    => 5,
				'member_type' => 'frivillige',
			],
			'RSRK Femunden'        => [
				'group_id'    => 5,
				'member_type' => 'frivillige',
			],
			// Vest.
			'RSRK Måløy'           => [
				'group_id'    => 6,
				'member_type' => 'frivillige',
			],
			'RSRK Bergen'          => [
				'group_id'    => 6,
				'member_type' => 'frivillige',
			],
			'RSRK Sunnhordland'    => [
				'group_id'    => 6,
				'member_type' => 'frivillige',
			],
			'RSRK Solund og Gulen' => [
				'group_id'    => 6,
				'member_type' => 'frivillige',
			],
			'RSRK Stavanger'       => [
				'group_id'    => 6,
				'member_type' => 'frivillige',
			],
			// Sør.
			'RSRK Kragerø'         => [
				'group_id'    => 7,
				'member_type' => 'frivillige',
			],
			'RSRK Kristiansand'    => [
				'group_id'    => 7,
				'member_type' => 'frivillige',
			],
			'RSRK Tønsberg'        => [
				'group_id'    => 7,
				'member_type' => 'frivillige',
			],
			'RSRK Horten'          => [
				'group_id'    => 7,
				'member_type' => 'frivillige',
			],
			'RSRK Skjeberg'        => [
				'group_id'    => 7,
				'member_type' => 'frivillige',
			],
			'RSRK Moss'            => [
				'group_id'    => 7,
				'member_type' => 'frivillige',
			],
			'RSRK Mandal'          => [
				'group_id'    => 7,
				'member_type' => 'frivillige',
			],
			// Øst.
			'RSRK Mjøsa'           => [
				'group_id'    => 8,
				'member_type' => 'frivillige',
			],
			'RSRK Oslo'            => [
				'group_id'    => 8,
				'member_type' => 'frivillige',
			],
		],
	];

	foreach ( $group_mappings as $key => $map ) {
		if ( isset( $ldap_attributes_raw[ $key ][0] ) && ! empty( $ldap_attributes_raw[ $key ][0] ) ) {
			$attr = $ldap_attributes_raw[ $key ][0];
			if ( 'department' === $key && isset( $map[ $attr ] ) ) {
				$group_args = [
					'name'        => $attr,
					'description' => '',
					'status'      => 'private',
					'creator_id'  => 2,
				];

				$slug = sanitize_title( $attr );

				$group_id = BP_Groups_Group::group_exists( $slug );

				if ( ! $group_id ) {
					$logger->info( 'New group created.' );
					$group_id = groups_create_group( $group_args );
				}
				if ( $group_id && ! groups_is_user_member( $id, $group_id ) ) {
					$logger->info( "User $id joined group $group_id." );
					groups_join_group( $group_id, $id );
					if ( ! get_user_meta( $id, 'main_group', true ) ) {
						update_user_meta( $id, 'main_group', $group_id );
					}
				} else {
					if ( ! get_user_meta( $id, 'main_group', true ) ) {
						update_user_meta( $id, 'main_group', $group_id );
					}
				}
				$logger->info( "$key found in AD" );
				if ( isset( $map[ $attr ]['group_id'] ) ) {
					$logger->info( "User $id mapped to group id $map[$value] based on $value" );
					groups_join_group( $map[ $attr ]['group_id'], $id );
				} else {
					$logger->warn( "Could not map $key for this user: $id" );
				}
			} else {
				$logger->warn( "No mapping set for $attr on user: $id" );
			}
		} else {
			$logger->warn( "Could not find $key for this user: $id" );
		}
	}

	$next_adi = NextADInt_Adi_Dependencies::getInstance();

	$connection = $next_adi->getLdapConnection();

	$adldap = $connection->getAdLdap();

	$username = $adi_user->getCredentials()->getSAMAccountName();

	$groups = $adldap->user_groups( $username, true, false );

	if ( is_array( $groups ) && in_array( 'Ansatte Land_GRP', $groups, true ) ) {
		bp_set_member_type( $id, 'ansatte' );
		if ( groups_join_group( 59, $id ) ) {
			if ( ! get_user_meta( $id, 'main_group', true ) ) {
				update_user_meta( $id, 'main_group', 59 );
			}
		} else {
			$logger->warn( "Could not set main group for user: $id" );
		}
	} elseif ( is_array( $groups ) && in_array( 'Ansatte_Sjø_GRP', $groups, true ) ) {
		bp_set_member_type( $id, 'ansatte' );
		if ( groups_join_group( 58, $id ) ) {
			if ( ! get_user_meta( $id, 'main_group', true ) ) {
				update_user_meta( $id, 'main_group', 58 );
			}
		} else {
			$logger->warn( "Could not set main group for user: $id" );
		}
	} elseif ( is_array( $groups ) && in_array( 'Frivillige', $groups, true ) ) {
		bp_set_member_type( $id, 'frivillige' );
	} else {
		$logger->warn( "Could not set member type for user: $id" );
	}
}
add_action( 'next_ad_int_user_after_update', 'nisje_rs_synchronize_ad', 10, 4 );

/**
 * Filter AD users
 *
 * @param array $users Users.
 * @return array $users Users.
 */
function nisje_rs_filter_users( $users ) {
	$next_adi = NextADInt_Adi_Dependencies::getInstance();

	$connection = $next_adi->getLdapConnection();

	$adldap = $connection->getAdLdap();

	$min_users = [];
	$rand_keys = array_rand( $users, 50 );

	foreach ( $rand_keys as $key ) {
		if ( isset( $users[ $key ] ) ) {
			$min_users[ $key ] = $users[ $key ];
		}
	}
	return $min_users;
}
add_filter( 'next_ad_int_sync_ad2wp_filter_synchronizable_users', 'nisje_rs_filter_users' );
