<?php
/**
 * Setup creators
 *
 * @package Nisje
 */

declare( strict_types = 1 );
defined( 'ABSPATH' ) || die( 'Shame on you' );

$taxonomy_type = nisje_get_setting( 'taxonomy_pub_name', 'rs_retriever' );

$args = apply_filters( 'nisje_taxononmy_nisje_retriever_pub_args', [
	'labels'            => [
		'name'          => esc_html_x( 'Creators', 'taxonomy general name', 'nisje-rs' ),
		'singular_name' => esc_html_x( 'Creator', 'taxonomy singular name', 'nisje-rs' ),
		'menu_name'     => esc_html__( 'Creators', 'nisje-rs' ),
	],
	'hierarchical'      => false,
	'show_admin_column' => true,
	'show_ui'           => true,
	'query_var'         => false,
	'rewrite'           => false,
	'show_in_rest'      => false,
] );

register_taxonomy( $taxonomy_type, [ nisje_get_setting( 'post_type_name', 'rs_retriever' ) ], $args );
