<?php
/**
 * Retriever
 *
 * @package Nisje
 */

declare( strict_types = 1 );
namespace Dekode\Nisje\Components;

defined( 'ABSPATH' ) || die( 'Shame on you' );

if ( ! class_exists( '\\Dekode\\Nisje\\Components\\RS_Retriever' ) && class_exists( '\\Dekode\\Nisje\\Components\\Component' ) ) {
	/**
	 * Retriever Component Class
	 */
	class RS_Retriever extends Component {
		/**
		 * Constructor
		 */
		public function __construct() {
			$path = trailingslashit( __DIR__ );

			parent::start(
				'rs-retriever',
				esc_html__( 'RS Retriever', 'nisje-rs' ),
				$path
			);
		}

		/**
		 * Global variables
		 */
		public function setup_globals() {
			$defaults = [
				'post_type_name'          => 'nisje-retriever',
				'post_type_rest_endpoint' => 'nisje-retriever',
				// Taxonomy.
				'taxonomy_pub_name'       => 'nisje-retriever-pub',
				// Import user.
				'import_author'           => 1,
				'news_category'           => 55,
			];

			$this->settings = wp_parse_args( $this->settings, $defaults );
		}

		/**
		 * Global variables
		 */
		public function setup_filters() {
			add_filter( 'rest_endpoints', [ $this, 'restrict_api_access' ] );
		}

		/**
		 * Register content types
		 */
		public function register_content_types() {
			// Post Types.
			$this->include_file( 'post-types/post-type-nisje-retriever.php' );
			// Taxonomies.
			$this->include_file( 'taxonomies/taxonomy-nisje-retriever-pub.php' );
		}

		/**
		 * Register REST Endpoints
		 */
		public function register_rest_routes() {
			$this->include_file( 'rest-handlers/extend-retriever.php' );
		}

		/**
		 * Register REST Endpoints
		 *
		 * @param array $endpoints Endpoints.
		 * @return array Optimized endpoints.
		 */
		public function restrict_api_access( $endpoints ) {
			if ( isset( $endpoints['/wp/v2/nisje-retriever/(?P<id>[\d]+)'] ) ) {
				unset( $endpoints['/wp/v2/nisje-retriever/(?P<id>[\d]+)'] );
			}

			return $endpoints;
		}
	}
}
