<?php
/**
 * Extend retriever
 *
 * @package Nisje
 */

declare( strict_types = 1 );
defined( 'ABSPATH' ) || die( 'Shame on you' );

register_rest_field( nisje_get_setting( 'post_type_rest_endpoint', 'rs_retriever' ), 'retriever', [
	'get_callback' => function( $object, $field, $request ) {
		$retval = [
			'link' => '',
		];

		if ( nisje_get_setting( 'post_type_name', 'rs_retriever' ) === $object['type'] ) {
			$retval['link'] = get_post_meta( $object['id'], 'retriever_link', true );
		}

		return $retval;
	},
	'schema'       => [
		'context'     => [ 'view', 'edit' ],
		'description' => esc_html__( 'Retriever info', 'nisje-rs' ),
		'type'        => 'array',
		'items'       => [
			'type' => 'string',
		],
		'readonly'    => true,
	],
] );
