<?php
/**
 * Extend settings.
 *
 * @package Nisje
 */

register_rest_field(
	'settings', 'segment', [
		'get_callback' => function ( $object ) {
			return [
				'tracking_code' => nisje_get_setting( 'tracking_code', 'segment' ),
			];
		},
		'schema'       => [
			'context'     => [ 'view' ],
			'description' => esc_html__( 'Segment Settings', 'nisje-segment' ),
			'type'        => 'array',
			'items'       => [
				'type' => 'string',
			],
			'readonly'    => true,
		],
	]
);
