<?php
/**
 * Plugin Name: Nisje - Segment Integration
 * Description: Bring Segment to Nisje
 * Author:      Dekode
 * Author URI:  https://dekode.no/en/
 * Version:     7.5.3
 * Text Domain: nisje-segment
 * Domain Path: /languages/
 * License:     GPLv2 or later (license.txt)
 *
 * @package Nisje
 */

declare( strict_types = 1 );
defined( 'ABSPATH' ) || die( 'Shame on you' );

define( 'NISJE_SEGMENT_VERSION', '7.5.3' );

/**
 * Load plugin textdomain.
 */
function nisje_segment_load_textdomain() {
	load_plugin_textdomain( 'nisje-segment', false, basename( __DIR__ ) . '/languages' );
}
add_action( 'plugins_loaded', 'nisje_segment_load_textdomain' );

/**
 * Include plugin components
 */
function nisje_segment_include() {
	require __DIR__ . '/segment/segment.php';
}
add_action( 'nisje_include', 'nisje_segment_include', 11 );
