<?php
/**
 * Setup Segment Settings.
 *
 * @package Nisje
 */

defined( 'ABSPATH' ) || die( 'Shame on you' );

$field_key_prefix = nisje_get_setting( 'field_key_prefix', 'segment' );

acf_add_local_field_group(
	[
		'key'                   => $field_key_prefix . '_segment',
		'title'                 => esc_html__( 'Segment', 'nisje-segment' ),
		'fields'                => [
			[
				'key'   => $field_key_prefix . '_tracking_code',
				'label' => esc_html__( 'Tracking Code', 'nisje-segment' ),
				'name'  => $field_key_prefix . '_tracking_code',
				'type'  => 'text',
			],
		],
		'location'              => [
			[
				[
					'param'    => 'options_page',
					'operator' => '==',
					'value'    => nisje_get_setting( 'settings_menu_key', 'segment' ),
				],
			],
		],
		'menu_order'            => 0,
		'position'              => 'normal',
		'style'                 => 'default',
		'label_placement'       => 'top',
		'instruction_placement' => 'label',
		'hide_on_screen'        => '',
		'active'                => 1,
		'description'           => '',
	]
);
