<?php
/**
 * Setup Format Taxonomy
 *
 * @package Nisje
 */

defined( 'ABSPATH' ) || die( 'Shame on you' );

$cap            = nisje_get_setting( 'capability_key', 'user-content' );
$post_type_name = nisje_get_setting( 'post_type_name', 'user-content' );
$taxonomy_name  = nisje_get_setting( 'taxonomy_format_name', 'user-content' );

$taxonomy_args = [
	'labels'            => [
		'name'              => esc_html_x( 'Formats', 'taxonomy general name', 'nisje-user-content' ),
		'singular_name'     => esc_html_x( 'Format', 'taxonomy singular name', 'nisje-user-content' ),
		'search_items'      => esc_html__( 'Search formats', 'nisje-user-content' ),
		'all_items'         => esc_html__( 'All formats', 'nisje-user-content' ),
		'parent_item'       => esc_html__( 'Parent', 'nisje-user-content' ),
		'parent_item_colon' => esc_html__( 'Parent:', 'nisje-user-content' ),
		'edit_item'         => esc_html__( 'Edit', 'nisje-user-content' ),
		'update_item'       => esc_html__( 'Update', 'nisje-user-content' ),
		'add_new_item'      => esc_html__( 'Add New Format', 'nisje-user-content' ),
		'new_item_name'     => esc_html__( 'New Format Name', 'nisje-user-content' ),
		'menu_name'         => esc_html__( 'Formats', 'nisje-user-content' ),
	],
	'hierarchical'      => false,
	'show_admin_column' => false,
	'show_ui'           => true,
	'query_var'         => false,
	'rewrite'           => false,
	'capabilities'      => [
		// Not allowed to edit or delete.
		'manage_terms' => '',
		'edit_terms'   => '',
		'delete_terms' => '',
		// Allow assigning terms.
		'assign_terms' => 'edit_posts',
	],
	'show_in_rest'      => false,
];

/**
 * Filters the taxonomy arguments for this taxonomy.
 *
 * @param array $taxonomy_args Taxonomy arguments.
 */
$taxonomy_args = apply_filters( 'nisje_taxonomy_user_content_format_args', $taxonomy_args );

/**
 * Filters the object types to connect to this taxonomy.
 *
 * @param array $post_types Post type arguments.
 */
$post_types   = [ $post_type_name ];
$object_types = apply_filters( 'nisje_taxonomy_user_content_format_object_types', $post_types );

register_taxonomy( $taxonomy_name, $object_types, $taxonomy_args );
