<?php
/**
 * Plugin Name: Nisje - User Content
 * Description: Bring User Content to Nisje
 * Author:      Dekode
 * Author URI:  https://dekode.no/en/
 * Version:     7.0.0
 * Text Domain: nisje-user-content
 * Domain Path: /languages/
 * License:     GPLv2 or later (license.txt)
 *
 * @package Nisje
 */

declare( strict_types = 1 );
defined( 'ABSPATH' ) || die( 'Shame on you' );

define( 'NISJE_USER_CONTENT_VERSION', '7.0.0' );

/**
 * Load plugin textdomain.
 */
function nisje_user_content_load_textdomain() {
	load_plugin_textdomain( 'nisje-user-content', false, basename( __DIR__ ) . '/languages' );
}
add_action( 'plugins_loaded', 'nisje_user_content_load_textdomain' );

/**
 * Include plugin components
 */
function nisje_user_content_include() {
	require __DIR__ . '/user-content/helpers.php';
	require __DIR__ . '/updates.php';
	require __DIR__ . '/user-content/user-content.php';
}
add_action( 'nisje_include', 'nisje_user_content_include', 11 );
