<?php
/**
 * User Content Component
 *
 * @package Nisje
 */

namespace Dekode\Nisje\Components;

defined( 'ABSPATH' ) || die( 'Shame on you' );

/**
 * Register User Content Component
 */
function register_user_content_component() {
	require __DIR__ . '/class-user-content.php';
	nisje_register_component( new \Dekode\Nisje\Components\User_Content() );
}
add_action( 'nisje_register_components', __NAMESPACE__ . '\register_user_content_component' );

/**
 * Update group last activity
 *
 * @param WP_Post         $post     Inserted or updated post object.
 * @param WP_REST_Request $request  Request object.
 * @param bool            $creating True when creating a post, false when updating.
 */
function update_group_last_activity( $post, $request, $creating ) {
	if ( isset( $request['group_id'] ) ) {
		$group_id = (int) $request['group_id'];

		if ( $creating ) {
			\groups_update_groupmeta( $group_id, 'last_activity', \bp_core_current_time() );
		}
	}
}
add_action( 'rest_after_insert_nisje-user-content', __NAMESPACE__ . '\\update_group_last_activity', 10, 3 );
