<?php
/**
 * Extend user content endpoint.
 *
 * @package Nisje
 */

use LanguageDetection\Language;

/**
 * Get language
 *
 * @param string $content Content string.
 */
function nisje_get_content_language( string $content ): string {
	$ld   = new Language( [ 'en', 'ar', 'nb' ] );
	$lang = $ld->detect( $content )->__toString();

	return $lang;
}
