<?php
/**
 * Extend Settings Endpoint with Wiki Featured Posts
 *
 * @package Nisje
 */

// Add Featured Boxes.
register_rest_field(
	'settings', 'wiki_featured_boxes', [
		'get_callback' => function( $object ) {
			$retval = [];

			if ( is_user_logged_in() ) {
				$retval = nisje_get_setting( 'featured_boxes', 'wiki' );
			}

			return $retval;
		},
		'schema'       => [
			'context'     => [ 'view', 'edit' ],
			'description' => esc_html__( 'Array of featured boxes', 'nisje-wiki' ),
			'type'        => 'array',
			'items'       => [
				'type' => 'object',
			],
			'readonly'    => true,
		],
	]
);
