<?php
/**
 * Plugin Name: Nisje - Wiki
 * Description: Add a wiki to Nisje
 * Author:      Dekode
 * Author URI:  https://dekode.no/en/
 * Version:     5.1.0
 * Text Domain: nisje-wiki
 * Domain Path: /languages/
 * License:     GPLv2 or later (license.txt)
 *
 * @package Nisje
 */

declare( strict_types = 1 );
namespace Nisje\Wiki;

defined( 'ABSPATH' ) || die( 'Shame on you' );

define( 'NISJE_WIKI_VERSION', '5.1.0' );

/**
 * Filters
 */
add_action( 'plugins_loaded', __NAMESPACE__ . '\\load_textdomain' );
add_action( 'nisje_register_components', __NAMESPACE__ . '\\register_components' );

/**
 * Load plugin textdomain.
 */
function load_textdomain() {
	load_plugin_textdomain( 'nisje-wiki', false, basename( __DIR__ ) . '/languages' );
}

/**
 * Include plugin components
 */
function register_components() {
	require __DIR__ . '/wiki/class-wiki.php';

	nisje_register_component( new \Dekode\Nisje\Components\Wiki() );
}
