<?php
/**
 * Plugin Name: Nisje - Wiki
 * Description: Add a wiki to Nisje
 * Author:      Dekode
 * Author URI:  https://dekode.no/en/
 * Version:     7.5.1
 * Text Domain: nisje
 * License:     GPLv2 or later (license.txt)
 *
 * @package Nisje
 */

declare( strict_types = 1 );
namespace Nisje\Wiki;

defined( 'ABSPATH' ) || die( 'Shame on you' );

define( 'NISJE_WIKI_VERSION', '7.5.1' );

/**
 * Filters
 */
add_action( 'nisje_register_components', __NAMESPACE__ . '\\register_components' );

/**
 * Include plugin components
 */
function register_components() {
	require __DIR__ . '/wiki/class-wiki.php';

	nisje_register_component( new \Dekode\Nisje\Components\Wiki() );
}

/**
 * Remove create group wiki cap from backend. Hides the add new links.
 */
add_filter( 'user_has_cap', function( $caps ) {
	if ( is_admin() ) {
		unset( $caps['create_nisje_wiki_cap_groups'] );
	}

	return $caps;
} );

/**
 * Remove quick edit from group wiki posts.
 */
add_filter( 'post_row_actions', function( $actions, $post ) {
	// Check for your post type.
	if ( 'nisje-wiki-group' === $post->post_type ) {
		unset( $actions['inline hide-if-no-js'] );
	}

	return $actions;
}, 10, 2 );

/**
 * Edit link on group wiki posts should go to frontend.
 */
add_filter( 'get_edit_post_link', function( $link, $id ) {
	$current_post = get_post( $id );

	if ( ! $current_post || 'nisje-wiki-group' !== $current_post->post_type ) {
		return $link;
	}

	return home_url( '/groups/' . $current_post->post_parent . '/wiki/' . $current_post->ID . '/edit/' );
}, 10, 2 );

