<?php
/**
 * Setup Wiki settings.
 *
 * @package Nisje
 */

defined( 'ABSPATH' ) || die( 'Shame on you' );

acf_add_local_field_group(
	[
		'key'                   => 'nisje_wiki',
		'title'                 => esc_html__( 'Wiki Settings', 'nisje' ),
		'fields'                => [
			[
				'key'          => 'nisje_wiki_boxes',
				'label'        => esc_html__( 'Featured Boxes', 'nisje' ),
				'name'         => 'wiki_featured_boxes',
				'type'         => 'repeater',
				'layout'       => 'block',
				'button_label' => esc_html__( 'Add Box', 'nisje' ),
				'sub_fields'   => [
					[
						'key'           => 'nisje_wiki_box_image',
						'label'         => esc_html__( 'Image', 'nisje' ),
						'name'          => 'image',
						'type'          => 'image',
						'return_format' => 'array',
					],
					[
						'key'   => 'nisje_wiki_box_title',
						'label' => esc_html__( 'Title', 'nisje' ),
						'name'  => 'title',
						'type'  => 'text',
					],
					[
						'key'          => 'nisje_wiki_box_text',
						'label'        => esc_html__( 'Text', 'nisje' ),
						'name'         => 'text',
						'type'         => 'wysiwyg',
						'tabs'         => 'visual',
						'toolbar'      => 'link',
						'media_upload' => 0,
						'delay'        => 0,
					],
					[
						'key'           => 'nisje_wiki_box_link',
						'label'         => esc_html__( 'Link', 'nisje' ),
						'name'          => 'link',
						'type'          => 'link',
						'return_format' => 'array',
						'wrapper'       => [
							'width' => '50%',
							'class' => '',
							'id'    => '',
						],
					],
				],
			],
		],
		'location'              => [
			[
				[
					'param'    => 'options_page',
					'operator' => '==',
					'value'    => 'nisje-wiki',
				],
			],
		],
		'menu_order'            => 0,
		'position'              => 'normal',
		'style'                 => 'default',
		'label_placement'       => 'top',
		'instruction_placement' => 'label',
		'hide_on_screen'        => '',
		'active'                => 1,
		'description'           => '',
	]
);
