<?php
/**
 * Setup Wiki Categories
 *
 * @package Nisje
 */

defined( 'ABSPATH' ) || die( 'Shame on you' );

$cap = nisje_get_setting( 'capability_key', 'wiki' );

$args = [
	'labels'                => [
		'name'              => esc_html_x( 'Categories', 'taxonomy general name', 'nisje' ),
		'singular_name'     => esc_html_x( 'Category', 'taxonomy singular name', 'nisje' ),
		'search_items'      => esc_html__( 'Search categories', 'nisje' ),
		'all_items'         => esc_html__( 'All categories', 'nisje' ),
		'parent_item'       => esc_html__( 'Parent', 'nisje' ),
		'parent_item_colon' => esc_html__( 'Parent:', 'nisje' ),
		'edit_item'         => esc_html__( 'Edit', 'nisje' ),
		'update_item'       => esc_html__( 'Update', 'nisje' ),
		'add_new_item'      => esc_html__( 'Add New Category', 'nisje' ),
		'new_item_name'     => esc_html__( 'Category Name', 'nisje' ),
		'menu_name'         => esc_html__( 'Categories', 'nisje' ),
	],
	'hierarchical'          => true,
	'show_admin_column'     => true,
	'show_ui'               => true,
	'query_var'             => true,
	'rewrite'               => false,
	'capability_type'       => $cap,
	'capabilities'          => [],
	'show_in_rest'          => true,
	'rest_base'             => 'dekode-wiki-category',
	'rest_controller_class' => 'WP_REST_Terms_Controller',
	'show_in_graphql'       => true,
	'graphql_single_name'   => 'wikiCategory',
	'graphql_plural_name'   => 'wikiCategories',
];

$object_type = [ nisje_get_setting( 'post_type_name', 'wiki' ) ];

register_taxonomy( 'dekode-wiki-category', $object_type, $args );
