<?php
/**
 * Setup Wiki Post Type
 *
 * @package Nisje
 */

defined( 'ABSPATH' ) || die( 'Shame on you' );

$cap            = nisje_get_setting( 'capability_key', 'wiki' );
$post_type_name = nisje_get_setting( 'post_type_name', 'wiki' );
$rest_endpoint  = nisje_get_setting( 'post_type_rest_endpoint', 'wiki' );

$args = apply_filters(
	'nisje_wiki_post_type_args', [
		'labels'                => [
			'name'          => esc_html__( 'Wiki', 'nisje' ),
			'singular_name' => esc_html__( 'Wiki', 'nisje' ),
		],
		'public'                => true,
		'publicly_queryable'    => true,
		'exclude_from_search'   => false,
		'show_in_admin_bar'     => false,
		'show_in_nav_menus'     => false,
		'can_export'            => false,
		'show_ui'               => true,
		'query_var'             => false,
		'has_archive'           => false,
		'rewrite'               => [
			'slug'       => 'wiki/%post_id%',
			'with_front' => false,
		],
		'capability_type'       => $cap,
		'capabilities'          => [
			'create_posts'     => "create_{$cap}s",
			'delete_posts'     => "delete_{$cap}s",
			'upload_files_cpt' => "upload_files_{$cap}",
		],
		'map_meta_cap'          => true,
		'hierarchical'          => false,
		'menu_position'         => null,
		'menu_icon'             => 'dashicons-media-text',
		'supports'              => [
			'author',
			'title',
			'revisions',
			'editor',
			'thumbnail',
			'excerpt',
			'page-attributes',
		],
		'show_in_rest'          => true,
		'rest_base'             => $rest_endpoint,
		'rest_controller_class' => 'WP_REST_Posts_Controller',
		'show_in_graphql'       => true,
		'graphql_single_name'   => 'wiki',
		'graphql_plural_name'   => 'wikis',
	]
);

register_post_type( $post_type_name, $args ); // phpcs:ignore
