<?php
/**
 * Setup Wiki Component
 *
 * @package Nisje
 */

namespace Dekode\Nisje\Components;

/**
 * Wiki Component Class
 */
class Wiki extends Component {
	/**
	 * Constructor
	 */
	public function __construct() {
		$path = trailingslashit( dirname( __FILE__ ) );

		parent::start(
			'wiki',
			__( 'Wiki', 'nisje' ),
			$path
		);
	}

	/**
	 * Global variables
	 */
	public function setup_globals() {
		$this->field_key = 'nisje_wiki';
		$this->key       = 'di_wiki';

		$settings = get_option( 'nisje_wiki_settings' );
		if ( is_array( $settings ) && ! empty( $settings ) ) {
			foreach ( $settings as $key => $value ) {
				$this->settings[ $key ] = $value;
			}
		}

		$defaults = [
			// Public.
			'post_type_name'          => 'dekode-wiki',
			'post_type_rest_endpoint' => 'dekode-wiki',
			'capability_key'          => 'di_wiki', // nisje_wiki_cap.
			// General.
			'field_key'               => $this->field_key,
			'key'                     => $this->key,
		];

		$this->settings = wp_parse_args( $this->settings, $defaults );
	}

	/**
	 * Setup Filters
	 */
	public function setup_filters() {
		add_filter( 'nisje_rest_search_handlers', [ $this, 'add_search_handler' ] );
	}

	/**
	 * Register REST Endpoints
	 */
	public function register_rest_routes() {
		$this->include_file( 'rest-handlers/class-wiki-search-handler.php' );
	}

	/**
	 * Add search handler.
	 *
	 * @param array $handlers Handlers.
	 */
	public function add_search_handler( array $handlers ): array {
		$handlers[] = new \Wiki_Search_Handler();
		return $handlers;
	}
}
